function [ddelta_dy,delta,dy,Delta_y_UR_bot,Delta_y_UR_top,e_bot,e_top,E_bot,E_top,...
    flag_first_call,flag_loc_seismic,flag_merged,flag_merged_unc,flag_seismic,xi,...
    y_delta,y_tilde,y_tilde_unc] = ...
    fault_slip_delta(a,alpha,b,cheb_terms,colors,delta,delta_c,D_center,Delta_y_int,...
    eps_reg,eta_reg,flag_cheb,flag_cor,flag_decouple,flag_echo,flag_eig_use,flag_first_call,...
    flag_fric,flag_lag,flag_merged,flag_merged_unc,flag_plot_cap,flag_plot_diag,...
    flag_plot_eig,flag_plot_snap,flag_reg,flag_reset_p_inc,g,G,i_step,kappa,K_eff,...
    max_iter_coupled,mu_dyn,...
    mu_st,n_max_int,n_min_int,nu,p_0_center,p_inc,phi,rho_f,rho_s,sigma_v_0,theta,...
    tol_rel_coupled,y_delta,y_plot_max_delta_1,y_plot_min_delta_1,y_plot_max_delta_2,...
    y_plot_min_delta_2,y_tilde_0)
%
% Computes the slip gradient ddelta_dy and the slip delta.
%   y_bound = [y_minus y_plus] are the integration boundaries for a single slip patch (either
%   top or bottom) or merged slip patches. 
%   y_bound_0 are starting values for y_bound.
%   y_tilde = [y_tilde(1) y_tilde(2) y_tilde(3) y_tilde(4)] are the slip patch boundaries.
%   y_tilde_0 are starting values for y_tilde.
% Note: it is assumed that this function is called for depletion with a monotonuously
% decreasing pressure.
%

persistent ddelta_dy_top_store delta_store delta_top_store p_inc_store sigma_C_top_store ...
    y_bot_store y_delta_store y_tilde_store y_top_store 
% only for use in eigenvalue computation in the next pressure step (see at bottom of file)

% Compute auxiliary variables:
A = G / (2*pi*(1-nu));
small_y_delta = 1e-6;
N = cheb_terms; % number of terms in Chebyshev expansion
points_type = 1; % points z_j chosen as zeros of T_n(z) where -1 < z < 1
[T,z_j] = fault_slip_cheb_matrix_T(N,N,points_type); % T = N x N matrix with ...
    % first-kind Chebyshev polynomials as columns, discretized at points z_j
[U,~] = fault_slip_cheb_matrix_U(N,N,points_type); % U = N x N matrix with ...
    % second-kind Chebyshev polynomials as columns, discretized at points z_j

% Intialize:
flag_loc_seismic = 0; % indicates slip patch where seismicity occurs: 1 = bottom; 2 = top
Delta_y_UR_bot = 0;
Delta_y_UR_top = 0;
e_bot = 0;
e_top = 0;
E_bot = 0;
E_top = 0;
sigma_C_top = 0;

% Set solver options:
options = optimoptions(@fsolve,'display','off'); % overwrites default options for fsolve to ...
    % suppress output; change to 'iter', 'iter'-detailed', 'final' or 'final-detailed' for
    % debugging

% options = optimoptions(@fsolve,'display','off','Algorithm','trust-region'); % overwrites ...
%     % default options for fsolve

% options = optimoptions(@fsolve,'display','off','Algorithm','levenberg-marquardt'); % ...
%     % overwrites default options for fsolve

% options = optimoptions(@fsolve,'display','off','StepTolerance',1e-12,...
%     'FunctionTolerance',1e-12); % overwrites default options for fsolve

if flag_echo == 2
    fprintf('Solving for slip patch boundaries\r');
end

% A) Compute y_minus and y_plus such that conditions 1 and 2 are fulfilled, assuming there is
%    NO COUPLING between the patches:
flag_coupled = 0;
y_tilde_unc = zeros(1,4); % slip patch boundaries; intialization
flag_just_merged = 0; % auxiliary variable in A1) and A2) 

if flag_merged_unc == 0
    % A1) Compute y_minus and y_plus for bottom slip patch (uncoupled):
    y_bound_0 = [y_tilde_0(1) y_tilde_0(2)]; % starting values for bottom slip patch
    y_a = -a; % singular point for bottom slip patch
    n_int_bot = fault_slip_int_point(Delta_y_int,flag_merged_unc,n_max_int,n_min_int,y_a,...
        y_bound_0); % number of integration points    
    [y_bound,~,exitflag] = fsolve(@(y_bound) fault_slip_resid_bound(a,alpha,b,0,delta,...
        delta_c,0,D_center,eps_reg,eta_reg,flag_coupled,flag_fric,flag_merged_unc,flag_reg,...
        g,G,kappa,K_eff,mu_dyn,mu_st,n_int_bot,nu,p_0_center,p_inc,phi,rho_f,rho_s,...
        sigma_v_0,theta,y_a,y_bound,0,y_delta),y_bound_0,options);
    if 0 < exitflag % solution found
        y_tilde_unc(1) = y_bound(1);
        y_tilde_unc(2) = y_bound(2);
    else
        flag_merged_unc = 1; % no solution found; probably slip patches have merged
        flag_just_merged = 1; % auxiliary variable to ensure A2) is executed 
        y_tilde_unc(1) = y_tilde_0(1);
        y_tilde_unc(2) = (y_tilde_0(2)+y_tilde_0(3))/2; % assumes that starting value y_tilde_0
        %  has been defined as result from previous pressure step
        y_tilde_unc(3) = y_tilde_unc(2);
        y_tilde_unc(4) = y_tilde_0(4);
    end
end

if flag_merged_unc == 0 || flag_just_merged == 1
    if flag_just_merged == 1
        flag_merged_unc = 0; % temporarily set flag_merged_unc = 0 while A2) is executed 
    end
    % A2) Compute y_minus and y_plus for top slip patch (uncoupled):
    y_bound_0 = [y_tilde_0(3) y_tilde_0(4)]; % starting values for top slip patch
    y_a = a; % singular point for top slip patch
    n_int_top = fault_slip_int_point(Delta_y_int,flag_merged_unc,n_max_int,n_min_int,y_a,...
        y_bound_0); % number of integration points
    [y_bound,~,exitflag] = fsolve(@(y_bound) fault_slip_resid_bound(a,alpha,b,0,delta,...
        delta_c,0,D_center,eps_reg,eta_reg,flag_coupled,flag_fric,flag_merged_unc,flag_reg,...
        g,G,kappa,K_eff,mu_dyn,mu_st,n_int_top,nu,p_0_center,p_inc,phi,rho_f,rho_s,...
        sigma_v_0,theta,y_a,y_bound,0,y_delta),y_bound_0,options);
    if 0 < exitflag % solution found
        y_tilde_unc(3) = y_bound(1);
        y_tilde_unc(4) = y_bound(2);
    else
        flag_merged_unc = 1; % no solution found; probably slip patches have merged
        y_tilde_unc(1) = y_tilde_0(1);
        y_tilde_unc(2) = (y_tilde_0(2)+y_tilde_0(3))/2; % assumes that starting value ...
        % y_tilde_0 has been defined as result from previous pressure step
        y_tilde_unc(3) = y_tilde_unc(2);
        y_tilde_unc(4) = y_tilde_0(4);
    end
    if y_tilde_unc(2) > y_tilde_unc(3)
        flag_merged_unc = 1; % slip patches have merged
        if flag_echo > 0
            fprintf('\rSlip patches have merged                p_inc = %7.4f MPa\r\r',...
                p_inc/1e6);
        end
        y_tilde_unc(2) = (y_tilde_unc(2)+y_tilde_unc(3))/2;
        y_tilde_unc(3) = y_tilde_unc(2);
    end
    if flag_just_merged == 1
        flag_merged_unc = 1; % reset flag_merged_unc
    end   
end

if flag_merged == 0
    % A3) Compute slip gradient for bottom slip patch (uncoupled):
    [~,dy_bot,xi_bot,y_bot,y_tilde_unc(1),y_tilde_unc(2)] = ...
        fault_slip_compute_xi(flag_merged,n_int_bot,-a,y_tilde_unc(1),y_tilde_unc(2));
    [~,~,fun_3] = fault_slip_integrand(a,alpha,b,0,delta,delta_c,0,D_center,eps_reg,eta_reg,...
        flag_coupled,flag_fric,flag_merged,flag_reg,g,G,kappa,K_eff,mu_dyn,mu_st,nu,...
        p_0_center,p_inc,phi,rho_f,rho_s,sigma_v_0,theta,xi_bot,0,y_bot,y_delta,...
        y_tilde_unc(1),y_tilde_unc(2));
    ddelta_dy_bot = ( sqrt( (y_bot'-y_tilde_unc(1)).*(y_tilde_unc(2)-y_bot') ) ...
        / (pi^2*A) .* trapz(xi_bot,fun_3,2) )';

    if flag_cor == 1
        % Apply corrections to ensure correct sign of gradient near end points (uncoupled):
        n = n_int_bot(2)-2; % actual number of integration points for y < -a
        m = n_int_bot(4)-2; % actual number of integration points for -a < y
        n = round(n/10); % first 10% from bottom of bottom patch
        m = round(m/10); % last 10% to top of bottom patch
        ddelta_dy_bot(1:n) = max(0,ddelta_dy_bot(1:n));
        ddelta_dy_bot(end-m:end) = min(0,ddelta_dy_bot(end-m:end));
    end

    % A4) Compute slip for bottom slip patch (uncoupled):
    delta_bot = cumtrapz(y_bot,ddelta_dy_bot);
       
    % A5) Compute slip gradient for top slip patch (uncoupled):
    [~,dy_top,xi_top,y_top,y_tilde_unc(3),y_tilde_unc(4)] = ...
        fault_slip_compute_xi(flag_merged,n_int_top,a,y_tilde_unc(3),y_tilde_unc(4));
    [~,~,fun_3] = fault_slip_integrand(a,alpha,b,0,delta,delta_c,0,D_center,eps_reg,eta_reg,...
        flag_coupled,flag_fric,flag_merged,flag_reg,g,G,kappa,K_eff,mu_dyn,mu_st,nu,...
        p_0_center,p_inc,phi,rho_f,rho_s,sigma_v_0,theta,xi_top,0,y_top,y_delta,...
        y_tilde_unc(3),y_tilde_unc(4));
    ddelta_dy_top = ( sqrt( (y_top'-y_tilde_unc(3)).*(y_tilde_unc(4)-y_top') ) ...
        / (pi^2*A) .* trapz(xi_top,fun_3,2) )';

    if flag_cor == 1
        % Apply corrections to ensure correct sign of gradient near end points (uncoupled):
        n = n_int_top(2)-2; % actual number of integration points for y < a
        m = n_int_top(4)-2; % actual number of integration points for a < y
        n = round(n/10); % first 10% from bottom of top patch
        m = round(m/10); % last 10% to top of top patch
        ddelta_dy_top(1:n) = max(0,ddelta_dy_top(1:n));
        ddelta_dy_top(end-m:end) = min(0,ddelta_dy_top(end-m:end));
    end

    % A6) Compute slip for top slip patch (uncoupled):
    delta_top = cumtrapz(y_top,ddelta_dy_top);
   
    % A7) Combine data for bottom and top patches (uncoupled):
    ddelta_dy = [0 ddelta_dy_bot ddelta_dy_top 0];
    dy = [dy_bot dy_top];
    delta = [0 delta_bot delta_top 0];
    xi = [xi_bot xi_top];
    y_delta_min = min(y_plot_min_delta_1,min(y_bot)-small_y_delta);
    y_delta_max = max(max(y_top)+small_y_delta,y_plot_max_delta_1);
    y_delta = [y_delta_min y_bot y_top y_delta_max];
end

% B) Repeat the computation of y_minus and y_plus such that conditions 1 and 2 are fulfilled,
%    assuming there IS COUPLING between the patches (unless overridden by use of flag_decouple)
%    and iterate to convergence. The iteration also takes care of the slip-dependence of 
%    the fault friction in case of a slip weakening friction law (flag_fric > 1). 
if flag_merged == 0
    if flag_first_call == 1 
        flag_coupled = 0;
    else
        if flag_fric == 1 
            flag_coupled = 1; % always coupled simulation for constant friction
        else
            if flag_decouple == 1
                flag_coupled = 0; % overrides coupling to speed up simulation but leaves ...
                    % iteration intact to ensure proper treatment of slip weakening
            else
                flag_coupled = 1;
            end
        end
    end
    y_tilde = y_tilde_unc; % starting value for iterative improvement
end
flag_seismic = 0; % limit of aseismic slip has not yet been reached
converged = 0;
i_iter = 0;
while converged == 0 && flag_merged == 0 && flag_seismic == 0
    i_iter = i_iter + 1;
    if i_iter > max_iter_coupled
        error('\rMaximum nr. of iterations exceeded in fault_slip_delta.')
    end
    y_tilde_old = y_tilde; % to check convergence
    
    % B1) Compute y_minus and y_plus for bottom slip patch (coupled):
    y_bound_0 = [y_tilde(1) y_tilde(2)]; % starting values for bottom slip patch
    y_a = -a; % singular point for bottom slip patch
    [y_bound,~,exitflag] = fsolve(@(y_bound) fault_slip_resid_bound(a,alpha,b,ddelta_dy_top,...
        delta,delta_c,dy_top,D_center,eps_reg,eta_reg,flag_coupled,flag_fric,flag_merged,...
        flag_reg,g,G,kappa,K_eff,mu_dyn,mu_st,n_int_bot,nu,p_0_center,p_inc,phi,rho_f,rho_s,...
        sigma_v_0,theta,y_a,y_bound,y_top,y_delta),y_bound_0,options);
    if 0 < exitflag % solution found
        y_tilde(1) = y_bound(1);
        y_tilde(2) = y_bound(2);
        if ~isreal(y_tilde(1))
            error('\rComplex value found for y_tilde_1.');
        end
        if ~isreal(y_tilde(2))
            error('\rComplex value found for y_tilde_2.');
        end
    else
        if flag_fric == 1 % constant friction
            flag_merged = 1;
            if flag_echo == 2
                fprintf('Number of integration points = %1.0i\r',n_int_bot(6)+n_int_top(6));
                fprintf('Number of iterations = %2.0i\r',i_iter);
            end
        else % slip-weakening friction
            if flag_echo == 2
                fprintf('Number of integration points = %1.0i\r',n_int_bot(6)+n_int_top(6));
                fprintf('Number of iterations = %2.0i\r',i_iter);
            end
            if flag_echo > 0
                fprintf('\rFailure to converge in bottom patch;')
                fprintf('\rseismic slip possibly occurs            p_inc = %7.4f MPa\r\r',...
                    p_inc/1e6);
            end
            flag_seismic = 1;
            flag_loc_seismic = 1; % location of seismic slip
            flag_lag = 1; % may overwrite pre-set value
        end
    end
    
    if flag_merged == 0 && flag_seismic == 0
        % B2) Compute y_minus and y_plus for top slip patch (coupled):
        y_bound_0 = [y_tilde(3) y_tilde(4)]; % starting values for top slip patch
        y_a = a; % singular point for top slip patch
        [y_bound,~,exitflag] = fsolve(@(y_bound) fault_slip_resid_bound(a,alpha,b,...
            ddelta_dy_bot,delta,delta_c,dy_bot,D_center,eps_reg,eta_reg,flag_coupled,...
            flag_fric,flag_merged,flag_reg,g,G,kappa,K_eff,mu_dyn,mu_st,n_int_top,nu,...
            p_0_center,p_inc,phi,rho_f,rho_s,sigma_v_0,theta,y_a,y_bound,y_bot,y_delta),...
            y_bound_0,options);
        if 0 < exitflag % solution found
            y_tilde(3) = y_bound(1);
            y_tilde(4) = y_bound(2);
        else
            if flag_fric == 1 % constant friction
                flag_merged = 1;
                if flag_echo == 2
                    fprintf('Number of integration points = %1.0i\r',...
                        n_int_bot(6)+n_int_top(6));
                    fprintf('Number of iterations = %2.0i\r',i_iter);
                end                
            else % slip-weakening friction
                if flag_echo == 2
                    fprintf('Number of integration points = %1.0i\r',...
                        n_int_bot(6)+n_int_top(6));
                    fprintf('Number of iterations = %2.0i\r',i_iter);
                end
            if flag_echo > 0
                fprintf('\rFailure to converge in top patch;')
                fprintf('\rseismic slip possibly occurs            p_inc = %7.4f MPa\r\r',...
                    p_inc/1e6);
            end
                flag_seismic = 1;
                flag_loc_seismic = 2; % location of seismic slip
                flag_lag = 1; % may overwrite pre-set value
            end
        end
    end
    
    if flag_merged == 0 && flag_seismic == 0
        % Check convergence:
        check_y_tilde = (y_tilde-y_tilde_old) * (y_tilde - y_tilde_old)'; 
        if check_y_tilde/(y_tilde_old*y_tilde_old') < tol_rel_coupled
            converged = 1;
            if flag_echo == 2
                fprintf('Number of integration points = %1.0i\r',n_int_bot(6)+n_int_top(6));
                fprintf('Number of iterations = %1.0i\r',i_iter);
            end
        else
            converged = 0;
        end
    end
    
    if flag_merged == 0 && flag_seismic == 0
        % B3) Compute slip gradient for bottom slip patch (coupled):
        [~,dy_bot,xi_bot,y_bot,y_tilde(1),y_tilde(2)] = ...
            fault_slip_compute_xi(flag_merged,n_int_bot,-a,y_tilde(1),y_tilde(2));
        [~,~,fun_3] = fault_slip_integrand(a,alpha,b,ddelta_dy_top,delta,delta_c,dy_top,...
            D_center,eps_reg,eta_reg,flag_coupled,flag_fric,flag_merged,flag_reg,g,G,kappa,...
            K_eff,mu_dyn,mu_st,nu,p_0_center,p_inc,phi,rho_f,rho_s,sigma_v_0,theta,xi_bot,...
            y_top,y_bot,y_delta,y_tilde(1),y_tilde(2));
        ddelta_dy_bot = ( sqrt( (y_bot'-y_tilde(1)).*(y_tilde(2)-y_bot') ) ...
            / (pi^2*A) .* trapz(xi_bot,fun_3,2) )';

        if flag_cor == 1
            % Apply corrections to ensure correct sign of gradient near end points (coupled):
            n = n_int_bot(2)-2; % actual number of integration points for y < -a
            m = n_int_bot(4)-2; % actual number of integration points for -a < y
            n = round(n/10); % first 10% from bottom of bottom patch
            m = round(m/10); % last 10% to top of bottom patch
            ddelta_dy_bot(1:n) = max(0,ddelta_dy_bot(1:n));
            ddelta_dy_bot(end-m:end) = min(0,ddelta_dy_bot(end-m:end));
        end

        % B4) Compute slip for bottom slip patch (coupled):
        delta_bot = cumtrapz(y_bot,ddelta_dy_bot);
   
        % B5) Compute slip gradient for top slip patch (coupled):
        [~,dy_top,xi_top,y_top,y_tilde(3),y_tilde(4)] = ...
            fault_slip_compute_xi(flag_merged,n_int_top,a,y_tilde(3),y_tilde(4));
        [~,~,fun_3] = fault_slip_integrand(a,alpha,b,ddelta_dy_bot,delta,delta_c,dy_bot,...
            D_center,eps_reg,eta_reg,flag_coupled,flag_fric,flag_merged,flag_reg,g,G,kappa,...
            K_eff,mu_dyn,mu_st,nu,p_0_center,p_inc,phi,rho_f,rho_s,sigma_v_0,theta,xi_top,...
            y_bot,y_top,y_delta,y_tilde(3),y_tilde(4));
         ddelta_dy_top = ( sqrt( (y_top'-y_tilde(3)).*(y_tilde(4)-y_top') ) ...
             / (pi^2*A) .* trapz(xi_top,fun_3,2) )';
        
        if flag_cor == 1
            % Apply corrections to ensure correct sign of gradient near end points (coupled):
            n = n_int_top(2)-2; % actual number of integration points for y < a
            m = n_int_top(4)-2; % actual number of integration points for a < y
            n = round(n/10); % first 10% from bottom of top patch
            m = round(m/10); % last 10% to top of top patch
            ddelta_dy_top(1:n) = max(0,ddelta_dy_top(1:n));
            ddelta_dy_top(end-m:end) = min(0,ddelta_dy_top(end-m:end));
        end
        
        % B6) Compute slip for top slip patch (coupled):
        delta_top = cumtrapz(y_top,ddelta_dy_top);
        
        % B7) Combine data for bottom and top patches (coupled):
        ddelta_dy = [0 ddelta_dy_bot ddelta_dy_top 0];
        dy = [dy_bot dy_top];
        delta = [0 delta_bot delta_top 0];
        xi = [xi_bot xi_top];
        y_delta_min = min(y_plot_min_delta_1,min(y_bot)-small_y_delta);
        y_delta_max = max(max(y_top)+small_y_delta,y_plot_max_delta_1);
        y_delta = [y_delta_min y_bot y_top y_delta_max];
    end
end

if (flag_eig_use == 1 || flag_plot_eig == 1) ...
    && flag_fric > 1 && flag_merged == 0 && flag_seismic == 0 && flag_first_call ~= 1 
    % B8) Compute eigenvalues and eigenvectors based on linearization around current ...
    %     depletion pressure:
    if flag_lag == 1 % values from previous pressure step are used
        delta_loc = delta_store;
        p_inc_loc = p_inc_store;
        y_bot_loc = y_bot_store;
        y_delta_loc = y_delta_store;
        y_tilde_loc = y_tilde_store;
    else % values from current pressure step are used
        delta_loc = delta;
        p_inc_loc = p_inc;
        y_bot_loc = y_bot;
        y_delta_loc = y_delta;
        y_tilde_loc = y_tilde;
    end
    [Delta_y_UR_bot,Delta_y_UR_top,e_bot,e_top,E_bot,E_top] = ...
        fault_slip_eigen_cheb(a,alpha,b,cheb_terms,colors,...
        delta_loc,delta_c,D_center,0,eps_reg,eta_reg,flag_cheb,flag_fric,flag_loc_seismic,...
        flag_plot_cap,flag_plot_diag,flag_plot_eig,flag_reg,flag_seismic,g,kappa,K_eff,...
        G,mu_dyn,mu_st,nu,p_0_center,p_inc_loc,phi,rho_f,rho_s,sigma_v_0,theta,T,U,...
        y_bot_loc,y_delta_loc,y_plot_max_delta_2,y_plot_min_delta_2,y_tilde_loc,z_j);
end

if flag_eig_use == 1 ...
    && flag_fric > 1 && flag_merged == 0 && flag_seismic == 0 && flag_first_call ~= 1 
    % B9) Perform check for seismicity based on eigenvalue analysis:
    Delta_y_sim_bot = y_tilde(2) - y_tilde(1);
    Delta_y_sim_top = y_tilde(4) - y_tilde(3);
    Delta_y_eig_bot = 1/e_bot; % inverse of largest eigen value
    Delta_y_eig_top = 1/e_top;
    if Delta_y_sim_bot > Delta_y_eig_bot 
% %         [e_bot,e_top,~,flag_merged] = ...
% %             fault_slip_eigen_cheb_coupled(a,alpha,b,cheb_terms,colors,...
% %             delta_loc,delta_c,D_center,eps_reg,eta_reg,flag_fric,flag_loc_seismic,...
% %             flag_plot_diag,flag_plot_eig,flag_reg,flag_seismic,g,kappa,K_eff,G,mu_dyn,...
% %             mu_st,nu,p_0_center,p_inc_loc,phi,rho_f,rho_s,sigma_v_0,theta,T,U,y_delta_loc,...
% %             y_plot_max_delta_2,y_plot_min_delta_2,y_tilde_loc,z_j);
        [~,~,e_bot,e_top,~,~] = ...
            fault_slip_eigen_cheb(a,alpha,b,cheb_terms,colors,...
            delta_loc,delta_c,D_center,0,eps_reg,eta_reg,flag_cheb,flag_fric,flag_loc_seismic,...
            flag_plot_diag,flag_plot_eig,flag_reg,flag_seismic,g,kappa,K_eff,G,mu_dyn,...
            mu_st,nu,p_0_center,p_inc_loc,phi,rho_f,rho_s,sigma_v_0,theta,T,U,...
            y_bot_loc,y_delta_loc,y_plot_max_delta_2,y_plot_min_delta_2,y_tilde_loc,z_j);
        Delta_y_eig_bot = 1/e_bot; % inverse of largest eigen value
        if Delta_y_sim_bot > Delta_y_eig_bot 
            fprintf('\rSeismic slip occurs in bottom patch     p_inc = %7.4f MPa\r\r',...
                p_inc/1e6);
            flag_seismic = 1;
            flag_loc_seismic = 1; % location of seismic slip
        end
    end
    if Delta_y_sim_top > Delta_y_eig_top 
% %         [e_bot,e_top,~,flag_merged] = ...
% %             fault_slip_eigen_cheb_coupled(a,alpha,b,cheb_terms,colors,...
% %             delta_loc,delta_c,D_center,eps_reg,eta_reg,flag_fric,flag_loc_seismic,...
% %             flag_plot_diag,flag_plot_eig,flag_reg,flag_seismic,g,kappa,K_eff,G,mu_dyn,...
% %             mu_st,nu,p_0_center,p_inc_loc,phi,rho_f,rho_s,sigma_v_0,theta,T,U,y_delta_loc,...
% %             y_plot_max_delta_2,y_plot_min_delta_2,y_tilde_loc,z_j);
        [~,~,e_bot,e_top,~,~] = ...
            fault_slip_eigen_cheb(a,alpha,b,cheb_terms,colors,...
            delta_loc,delta_c,D_center,0,eps_reg,eta_reg,flag_cheb,flag_fric,...
            flag_loc_seismic,flag_plot_cap,flag_plot_diag,flag_plot_eig,flag_reg,...
            flag_seismic,g,kappa,K_eff,G,mu_dyn,mu_st,nu,p_0_center,p_inc_loc,phi,...
            rho_f,rho_s,sigma_v_0,theta,T,U,y_bot_loc,y_delta_loc,y_plot_max_delta_2,...
            y_plot_min_delta_2,y_tilde_loc,z_j);
        Delta_y_eig_top = 1/e_top;
        if Delta_y_sim_top > Delta_y_eig_top 
            fprintf('\rSeismic slip occurs in top patch        p_inc = %7.4f MPa\r\r',...
                p_inc/1e6);
            flag_seismic = 1;
            flag_loc_seismic = 2; % location of seismic slip
        end
    end
end

% B9) Check for merging:
if flag_merged == 0 && flag_seismic == 0
    if y_tilde(2) >= y_tilde(3)
        flag_merged = 1; % slip patches have merged
        y_tilde(2) = (y_tilde(2)+y_tilde(3))/2;
        y_tilde(3) = y_tilde(2);
    end
end

% C1) Compute y_minus and y_plus for a single, merged, patch:
if flag_merged == 1 && flag_seismic == 0
    y_bound_0 = [y_tilde_0(1) y_tilde_0(4)]; % starting values for merged slip patches
    y_a = [-a a]; % singular points for merged slip patches
    n_int_merged = fault_slip_int_point(Delta_y_int,flag_merged,n_max_int,n_min_int,...
        y_a,y_bound_0); % number of integration points
    if flag_fric == 1 && y_tilde_0(1) < 0.999 * b && y_tilde_0(4) > 0.999 * b % limits ...
        % almost reached
        y_tilde = y_tilde_0;
    else
        [y_bound,~,exitflag] = fsolve(@(y_bound) fault_slip_resid_bound(a,alpha,b,0,delta,...
            delta_c,0,D_center,eps_reg,eta_reg,flag_coupled,flag_fric,flag_merged,flag_reg,...
            g,G,kappa,K_eff,mu_dyn,mu_st,n_int_merged,nu,p_0_center,p_inc,phi,rho_f,rho_s,...
            sigma_v_0,theta,y_a,y_bound,0,y_delta),y_bound_0,options);
        if 0 < exitflag % solution found
            y_tilde(1) = y_bound(1);
            y_tilde(2) = (y_tilde_0(2)+y_tilde_0(3))/2; % assumes that starting value ...
            % y_tilde_0 has been defined as result from previous pressure step
            y_tilde(3) = y_tilde(2); % same comment as for y_tilde(2)
            y_tilde(4) = y_bound(2);
            if ~isreal(y_tilde(1))
                error('\rComplex value found for y_tilde_1.');
            end
            if ~isreal(y_tilde(4))
                error('\rComplex value found for y_tilde_4.');
            end
            if flag_echo == 2
                fprintf('Number of integration points = %1.0i\r',n_int_merged(6));
            end
        else
            error('\rNo boundaries found for merged patches.');
        end
    end
        
    % C2) Compute slip gradient for merged patches:
    if flag_seismic == 0
        y_a = [-a,a];
        [~,dy_merged,xi_merged,y_merged,y_tilde(1),y_tilde(4)] = ...
            fault_slip_compute_xi(flag_merged,n_int_merged,y_a,y_tilde(1),y_tilde(4));
        [~,~,fun_3] = fault_slip_integrand(a,alpha,b,0,delta,delta_c,0,D_center,eps_reg,...
            eta_reg,flag_coupled,flag_fric,flag_merged,flag_reg,g,G,kappa,K_eff,...
            mu_dyn,mu_st,nu,p_0_center,p_inc,phi,rho_f,rho_s,sigma_v_0,theta,xi_merged,0,...
            y_merged,y_delta,y_tilde(1),y_tilde(4));
        ddelta_dy_merged = ( sqrt( (y_merged'-y_tilde(1)).*(y_tilde(4)-y_merged') ) ...
            / (pi^2*A) .* trapz(xi_merged,fun_3,2) )';        
        
        % C3) Compute slip for merged patches:
        delta_merged = cumtrapz(y_merged,ddelta_dy_merged);
    
        if flag_cor == 1
            % Apply corrections to ensure correct sign of gradient near end points (coupled):
            n = n_int_merged(3)-2; % actual number of integr. points for y < -a (merged case)
            m = n_int_merged(5)-2; % actual number of integr. points for -a < y (merged case)
            n = round(n/10); % first 10% from bottom of merged patch
            m = round(m/10); % last 10% to top of merged patch
            ddelta_dy_merged(1:n) = max(0,ddelta_dy_merged(1:n));
            ddelta_dy_merged(end-m:end) = min(0,ddelta_dy_merged(end-m:end));
        end
        
        % C4) Combine data:
        ddelta_dy = [0 ddelta_dy_merged 0];
        dy = dy_merged;
        delta = [0 delta_merged 0];
        xi = xi_merged;
        y_delta_min = min(y_plot_min_delta_1,min(y_merged)-small_y_delta);
        y_delta_max = max(max(y_merged)+small_y_delta,y_plot_max_delta_1);
        y_delta = [y_delta_min y_merged y_delta_max];
    else
        ddelta_dy = 0; % dummy output
        dy = 0;        % dummy output
        delta = 0;     % dummy output
        xi = 0;        % dummy output
        y_delta = 0;   % dummy output
        y_tilde = y_tilde_0;
    end
end
y_tilde = [y_tilde(1) y_tilde(2) y_tilde(3) y_tilde(4)];

% D) Compute eigenvalues and eigenvectors:
if flag_seismic == 1 && flag_merged == 0
    if flag_lag == 1 % values from previous pressure step are used
        delta_loc = delta_store;
        p_inc_loc = p_inc_store;
        y_bot_loc = y_bot_store;
        y_delta_loc = y_delta_store;
        y_tilde_loc = y_tilde_store;
    else % values from current pressure step are used
        delta_loc = delta;
        p_inc_loc = p_inc;
        y_bot_loc = y_bot;
        y_delta_loc = y_delta;
        y_tilde_loc = y_tilde;
    end
% %     [e_bot,e_top,~,~] = ...
% %         fault_slip_eigen_cheb_coupled(a,alpha,b,cheb_terms,colors,...
% %         delta_loc,delta_c,D_center,eps_reg,eta_reg,flag_fric,flag_loc_seismic,...
% %         flag_plot_diag,flag_plot_eig,flag_reg,flag_seismic,g,kappa,K_eff,G,mu_dyn,...
% %         mu_st,nu,p_0_center,p_inc_loc,phi,rho_f,rho_s,sigma_v_0,theta,T,U,y_delta_loc,...
% %         y_plot_max_delta_2,y_plot_min_delta_2,y_tilde_loc,z_j);
    [Delta_y_UR_bot,Delta_y_UR_top,e_bot,e_top,~,~] = ...
        fault_slip_eigen_cheb(a,alpha,b,cheb_terms,colors,...
        delta_loc,delta_c,D_center,0,eps_reg,eta_reg,flag_cheb,flag_fric,flag_loc_seismic,...
        flag_plot_cap,flag_plot_diag,flag_plot_eig,flag_reg,flag_seismic,g,kappa,K_eff,G,...
        mu_dyn,mu_st,nu,p_0_center,p_inc_loc,phi,rho_f,rho_s,sigma_v_0,theta,T,U,...
        y_bot_loc,y_delta_loc,y_plot_max_delta_2,y_plot_min_delta_2,y_tilde_loc,z_j);
end

% % if flag_seismic == 1
% %     [e_bot,e_top,~,~] = ...
% %         fault_slip_eigen_cheb_coupled(a,alpha,b,cheb_terms,colors,...
% %         delta_loc,delta_c,D_center,eps_reg,eta_reg,flag_fric,flag_loc_seismic,...
% %         flag_plot_diag,flag_plot_eig,flag_reg,flag_seismic,g,kappa,K_eff,G,mu_dyn,...
% %         mu_st,nu,p_0_center,p_inc_loc,phi,rho_f,rho_s,sigma_v_0,theta,T,U,y_delta_loc,...
% %         y_plot_max_delta_2,y_plot_min_delta_2,y_tilde_loc,z_j);
% % end

% Additional diagnostic plots:
if flag_fric > 1 && flag_plot_diag == 1 && i_step > 1
    [~,~,~,sigma_C_top,~,~,~,~,~,~,~,~,~,~,~,~,~,~] = ...
        fault_slip_sigma(a,alpha,b,delta_store,delta_c,D_center,eps_reg,eta_reg,flag_fric,...
        flag_reg,g,kappa,K_eff,mu_dyn,mu_st,1,nu,p_0_center,p_inc,phi,rho_f,rho_s,...
        sigma_v_0,theta,y_delta_store,y_top_store,y_top_store);
    if flag_seismic == 1
        blue = colors(1,:);
        figure
        subplot(1,3,1)
%         x_plot_min = min(sigma_C_top_store/1e6);
%         x_plot_max = max(sigma_C_top_store/1e6);
        x_plot_min = min(sigma_C_top/1e6);
        x_plot_max = max(sigma_C_top/1e6);
        y_plot_min = y_plot_min_delta_2;
        y_plot_max = y_plot_max_delta_2;
        hold on
        line([x_plot_min x_plot_max],[0 0],'LineStyle','-','Color','k','LineWidth',0.5)
        line([0 0],[y_plot_min y_plot_max],'LineStyle','-','Color','k','LineWidth',0.5)
        line([x_plot_min x_plot_max],[-a -a],'LineStyle',':','Color','k','LineWidth',1)
        line([x_plot_min x_plot_max],[a a],'LineStyle',':','Color','k','LineWidth',1)
        line([x_plot_min x_plot_max],[y_tilde_store(3) y_tilde_store(3)],'LineStyle','-','Color',blue,'LineWidth',0.5)
        line([x_plot_min x_plot_max],[y_tilde_store(4) y_tilde_store(4)],'LineStyle','-','Color',blue,'LineWidth',0.5)
%         plot(sigma_C_top_store/1e6,y_top_store,'-r','LineWidth',1.5)
        plot(sigma_C_top/1e6,y_top_store,'-r','LineWidth',1.5)
        hold off
        %     axis([x_plot_min x_plot_max y_plot_min y_plot_max])
        axis([-inf inf y_plot_min y_plot_max])
        box on
        xlabel('$\Sigma_{\it C}$ (MPa)','Interpreter','latex','FontSize',11)
        ylabel('$\it y$ (m)','Interpreter','latex','FontSize',11)
        if flag_plot_cap == 1
            [t,s] = title('delta','Simulation'); % first line: plot file locator
            t.Color = 'r';
            t.FontSize = 10;
            s.FontSize = 10;
            t.FontWeight = 'normal';
            s.FontWeight = 'normal';
        end
        
        subplot(1,3,2)
        x_plot_min = min(ddelta_dy_top_store*1e3);
        x_plot_max = max(ddelta_dy_top_store*1e3);
        y_plot_min = y_plot_min_delta_2;
        y_plot_max = y_plot_max_delta_2;
        hold on
        line([x_plot_min x_plot_max],[0 0],'LineStyle','-','Color','k','LineWidth',0.5)
        line([0 0],[y_plot_min y_plot_max],'LineStyle','-','Color','k','LineWidth',0.5)
        line([x_plot_min x_plot_max],[-a -a],'LineStyle',':','Color','k','LineWidth',1)
        line([x_plot_min x_plot_max],[a a],'LineStyle',':','Color','k','LineWidth',1)
        line([x_plot_min x_plot_max],[y_tilde_store(3) y_tilde_store(3)],'LineStyle','-','Color',blue,'LineWidth',0.5)
        line([x_plot_min x_plot_max],[y_tilde_store(4) y_tilde_store(4)],'LineStyle','-','Color',blue,'LineWidth',0.5)
        plot(ddelta_dy_top_store*1e3,y_top_store,'-r','LineWidth',1.5)
        hold off
        %     axis([x_plot_min x_plot_max y_plot_min y_plot_max])
        axis([-inf inf y_plot_min y_plot_max])
        box on
        xlabel('$\nabla{\it\delta}$ (mm/m)','Interpreter','latex','FontSize',11)
        ylabel('$\it y$ (m)','Interpreter','latex','FontSize',11)
        
        subplot(1,3,3)
        x_plot_min = min(delta_top_store*1e3);
        x_plot_max = max(delta_top_store*1e3);
        y_plot_min = y_plot_min_delta_2;
        y_plot_max = y_plot_max_delta_2;
        hold on
        line([x_plot_min x_plot_max],[0 0],'LineStyle','-','Color','k','LineWidth',0.5)
        line([0 0],[y_plot_min y_plot_max],'LineStyle','-','Color','k','LineWidth',0.5)
        line([x_plot_min x_plot_max],[-a -a],'LineStyle',':','Color','k','LineWidth',1)
        line([x_plot_min x_plot_max],[a a],'LineStyle',':','Color','k','LineWidth',1)
        line([x_plot_min x_plot_max],[y_tilde_store(3) y_tilde_store(3)],'LineStyle','-','Color',blue,'LineWidth',0.5)
        line([x_plot_min x_plot_max],[y_tilde_store(4) y_tilde_store(4)],'LineStyle','-','Color',blue,'LineWidth',0.5)
        plot(delta_top_store*1e3,y_top_store,'-r','LineWidth',1.5)
        hold off
        %     axis([x_plot_min x_plot_max y_plot_min y_plot_max])
        axis([-inf inf y_plot_min y_plot_max])
        box on
        xlabel('$\it\delta$ (mm)','Interpreter','latex','FontSize',11)
        ylabel('$\it y$ (m)','Interpreter','latex','FontSize',11)
    end
end

if flag_fric > 1 || flag_first_call == 1 
    % Save persistent values for use in eigenvalue computation in the next pressure step:
    ddelta_dy_top_store = ddelta_dy_top; % for diagnostic plots 
    delta_store = delta;
    delta_top_store = delta_top; % for diagnostic plots
    p_inc_store = p_inc;
    sigma_C_top_store = sigma_C_top; % for diagnostic plots
    y_bot_store = y_bot;
    y_delta_store = y_delta;
    y_tilde_store = y_tilde;
    y_top_store = y_top; % for diagnostic plots
end
flag_first_call = 0;


